/*  Part of SWI-Prolog

    Author:        Jan Wielemaker
    E-mail:        J.Wielemaker@cs.vu.nl
    WWW:           http://www.swi-prolog.org
    Copyright (C): 2002-2010, University of Amsterdam
			      VU University Amsterdam

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301  USA
*/

#include "SWI-Prolog.h"
#include "debug.h"

#ifdef O_DEBUG

static int dbg_level;

int
rdf_debuglevel()
{ return dbg_level;
}


foreign_t
rdf_debug(term_t level)
{ if ( !PL_get_integer(level, &dbg_level) )
    return FALSE;

  return TRUE;
}

#endif

#if __GNUC__ == 4 && __GNUC_MINOR__ == 7
void
gcc_47_dummy(void *ptr)
{ static void *p;

  if ( p != ptr )
    p = ptr;
}
#endif
