using System;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using System.Xml;
using System.Text;
using System.Text.RegularExpressions;
using System.Web.Services;
using System.Web.Services.Protocols;
using LogicEngineLib;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class Service : System.Web.Services.WebService
{
    public static LogicEXE logServer = null;
    public static string TempDirectory = string.Empty;
    public static string IniFile = string.Empty;
    public static string PlCon = string.Empty;
    public static int TimeOut = 0;

    static Service()
    {
        TempDirectory = ConfigurationManager.AppSettings["TempDirectory"];
        IniFile = ConfigurationManager.AppSettings["IniFile"];
        PlCon = ConfigurationManager.AppSettings["PlCon"];
        TimeOut = int.Parse(ConfigurationManager.AppSettings["TimeOutMilliseconds"]);
        logServer = new LogicEXE(TempDirectory,PlCon,TimeOut);
        logServer.Consult(IniFile);
    }

    public Service () 
    {

    }

    [WebMethod]
    public string Query(string query)
    {
        return logServer.Query(query, false);
    }

    [WebMethod]
    public string QueryDistinct(string query)
    {
        return logServer.Query(query, true);
    }

    [WebMethod]
    public bool IsTrue(string statement)
    {
        return logServer.IsTrue(statement);
    }

    [WebMethod]
    public string Listing()
    {
        return logServer.Listing();
    }

    [WebMethod]
    public string Call(string statement)
    {
        return logServer.Call(statement);
    }

    [WebMethod]
    public string Assert(string statement)
    {
        return logServer.Assert(statement);
    }

    [WebMethod]
    public string Restart()
    {
        logServer.ReStart();
        System.Threading.Thread.Sleep(2000);
        logServer.Consult(IniFile);
        return "RESTARTED";
    }

    [WebMethod]
    public string SaveChanges()
    {
        logServer.Save(IniFile.Replace('\\', '/'));
        return "SAVE ACCOMPLISED";
    }
}
